import styles from "./index.module.scss";
import Layout from "~/components/layout";
import { Space, Image as AImage, Row, Col, Button, Divider, Badge } from "antd";
import { useState } from "react";
import { RightOutlined } from "@ant-design/icons";
import Image from "next/image";
import errImg from "~/assets/errImg";
import { useRouter } from "next/router";

export default function MallDetail() {
  const [visible, setVisible] = useState(false);
  const router = useRouter();
  const { pid } = router.query;

  return (
    <Layout>
      <div className="page" style={{ marginTop: 20, backgroundColor: "#fff" }}>
        <div style={{ display: "none" }}>
          <AImage.PreviewGroup
            preview={{ visible, onVisibleChange: (vis) => setVisible(vis) }}
          >
            <AImage src="https://gw.alipayobjects.com/zos/antfincdn/LlvErxo8H9/photo-1503185912284-5271ff81b9a8.webp" />
            <AImage src="https://gw.alipayobjects.com/zos/antfincdn/cV16ZqzMjW/photo-1473091540282-9b846e7965e3.webp" />
            <AImage src="https://gw.alipayobjects.com/zos/antfincdn/x43I27A55%26/photo-1438109491414-7198515b166b.webp" />
          </AImage.PreviewGroup>
        </div>
        <Space size={30} style={{ padding: "22px 24px 0" }}>
          {/* 商品图 */}
          <AImage
            preview={{ visible: false }}
            width={200}
            src="https://gw.alipayobjects.com/zos/antfincdn/LlvErxo8H9/photo-1503185912284-5271ff81b9a8.webp"
            onClick={() => setVisible(true)}
          />
          <Space direction="vertical" size={17}>
            <div className={`${styles.font1} ${styles.ellipsis}`}>
              入云龙1550
            </div>
            <div className={`${styles.font2} ${styles.ellipsis}`}>
              交通事故处理、违章取证、指挥调度、日常巡
            </div>
            <Space
              size={24}
              direction="vertical"
              style={{
                padding: "24px 40px 24px 23px",
                border: "1px solid #EDEDED",
                width: 470,
              }}
            >
              <Row wrap={false}>
                <Col flex="60px" className={styles.font3}>
                  选择
                </Col>
                <Col
                  flex="auto"
                  className={styles.font4}
                  style={{ cursor: "pointer" }}
                >
                  已选：1件
                </Col>
                <Col style={{ cursor: "pointer" }}>
                  <RightOutlined />
                </Col>
              </Row>
              <Row wrap={false}>
                <Col flex="60px" className={styles.font3}>
                  送至
                </Col>
                <Col flex="auto" style={{ cursor: "pointer" }}>
                  <Space size={5}>
                    <Image
                      alt=""
                      width={18}
                      height={18}
                      src={require("./assets/locate.png")}
                    ></Image>
                    <span className={`${styles.font3} ${styles.ellipsis}`}>
                      广东深圳市南山区万科云城创新谷6栋A座…
                    </span>
                  </Space>
                  <div className={styles.font4} style={{ marginTop: 7 }}>
                    现货，22:00前下单，预计后天（8月30日）送达
                  </div>
                </Col>
              </Row>
            </Space>
            <Space size={12} style={{ marginTop: 20 }}>
              <Button className={styles.btn1}>加入购物车</Button>
              <Button className={styles.btn2} type="primary">
                提交意向
              </Button>
              <Space size={20} style={{ marginLeft: 19 }}>
                <div style={{ textAlign: "center", cursor: "pointer" }}>
                  <Image
                    alt=""
                    src={require("./assets/phone.png")}
                    width={20}
                    height={20}
                  ></Image>
                  <div className={styles.font5} style={{ marginTop: 5 }}>
                    电话
                  </div>
                </div>
                <div style={{ textAlign: "center", cursor: "pointer" }}>
                  <Badge count={55} size="small">
                    <Image
                      alt=""
                      src={require("./assets/car.png")}
                      width={20}
                      height={20}
                    ></Image>
                  </Badge>
                  <div className={styles.font5} style={{ marginTop: 5 }}>
                    购物车
                  </div>
                </div>
              </Space>
            </Space>
          </Space>
        </Space>
        <Divider className={styles.divider}>商品详情</Divider>
        <div style={{ textAlign: "center" }}>
          <AImage fallback={errImg} width={1080}></AImage>
        </div>
      </div>
    </Layout>
  );
}
